//
//  OPPlayer.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/6/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPPlayer.h"
#import "OPStatusHeart.h"
#import "OPItem.h"
#import "OPWoodSword.h"
#import "OPTextureManager.h"
#import "OPSword.h"

@implementation OPPlayer
- (id)initWithLocation:(OPPoint)inLocation andSize:(OPSize)inSize
{
	self = [super initWithLocation:inLocation andSize:inSize];
	if(self != nil) {
		heartCount = 3;
		maxHealth = heartCount * 2;
		lastDirectionMoved = OPRight;
		currentHealth = maxHealth;
		moveSpeed = (240 * UPDATE_INTERVAL);
		health = [[NSMutableArray alloc] initWithCapacity:3];
		lastAttackTime = [NSDate timeIntervalSinceReferenceDate];
		int i;
		OPStatusHeart *heart = nil;
		int x = 0, yloc = 0;
		for(i = 0; i < heartCount; i++, x++) {
			heart = [[[OPStatusHeart alloc] init] autorelease];
			[heart setLocationX:x * 20];	[heart setLocationY:yloc];
			[health addObject:heart];
		}
		weapon = [[OPWoodSword alloc] initWithType:@"Sword"];
		weaponIcon = [[OPItem alloc] initWithLocation:OPMakePoint(0,0) andSize:OPMakeSize(32,32)];
		[weaponIcon addTextureID:[[OPTextureManager sharedManager] textureWithName:@"Sword_Wood_Up"] withName:@"Sword_Wood_Up"];
	}
	return self;
}

- (void)dealloc
{
	[health release];
	[super dealloc];
}


- (OPRect)collisionRect
{
	return NSMakeRect([self locationX] + 2, [self locationY], size.width - 4, size.height / 2);
}

- (void)draw
{
	if(attacking) {
		[self setWeaponLocation];
		[weapon draw];
	}
	/*glBegin(GL_LINE_LOOP); {
		glColor3d(0, 0, 0);
		glVertex2d(location.x, location.y);
		glVertex2d(location.x + 32, location.y);
		glVertex2d(location.x + 32, location.y + 32);
		glVertex2d(location.x, location.y + 32);
		glColor3d(1.0, 1.0, 1.0);
	}
	glEnd();
	OPRect collisionRect = [self collisionRect];
	glBegin(GL_LINE_LOOP); {
		glColor3d(1, 0, 0);
		glVertex2d(collisionRect.origin.x, collisionRect.origin.y);
		glVertex2d(collisionRect.origin.x + collisionRect.size.width, collisionRect.origin.y);
		glVertex2d(collisionRect.origin.x + collisionRect.size.width, collisionRect.origin.y + collisionRect.size.height);
		glVertex2d(collisionRect.origin.x, collisionRect.origin.y + collisionRect.size.height);
		glColor3d(1.0, 1.0, 1.0);
	}
	glEnd();*/
	[super draw];
}

- (void)update
{
	numberOfUpdates++;
	const int MIN_ANIMATION_UPDATES = 7;
	const int MIN_ANIMATION_UPDATES_ATTACK = 12;
	if(attacking) {
		numberOfUpdatesAttack++;
		[self showAttackAnimation];
	}else if(numberOfUpdates >= MIN_ANIMATION_UPDATES) {
		numberOfUpdates = 0;
		[self showMovingAnimation];
	}

	if(numberOfUpdatesAttack >= MIN_ANIMATION_UPDATES_ATTACK) {
		numberOfUpdatesAttack = 0;
		attacking = NO;
	}

	[super update];
}

- (void)showAttackAnimation
{
	[weapon setVisible:YES];
	switch(lastDirectionMoved) {
		case OPUp:
			textureID = [self textureWithName:@"player_up_attack"];
			break;
		case OPDown:
			textureID = [self textureWithName:@"player_down_attack"];
			break;
		case OPLeft:
			textureID = [self textureWithName:@"player_left_attack"];
			break;
		case OPRight:
			textureID = [self textureWithName:@"player_right_attack"];
			break;
	}			
}

- (void)showMovingAnimation
{
	if([self isMoving]) {
		NSString *directionStr = @"";
		if([self isMovingUp]) {
			lastDirectionMoved = OPUp;
			directionStr = @"up";
		} else if([self isMovingDown]) {
			lastDirectionMoved = OPDown;
			directionStr = @"down";
		} else if([self isMovingLeft]) {
			lastDirectionMoved = OPLeft;
			directionStr = @"left";
		} else if([self isMovingRight]) {
			lastDirectionMoved = OPRight;
			directionStr = @"right";
		}		
		if(textureID == [self textureWithName:[NSString stringWithFormat:@"player_%@02", directionStr]]) {
			textureID = [self textureWithName:[NSString stringWithFormat:@"player_%@01",directionStr]];
		} else {
			textureID = [self textureWithName:[NSString stringWithFormat:@"player_%@02", directionStr]];
		}
		
	} else {
		[self restoreLastMoveDirection];
	}
}

- (void)restoreLastMoveDirection
{
	switch(lastDirectionMoved) {
		case OPUp:
			textureID = [self textureWithName:@"player_up01"];
			break;
		case OPDown:
			textureID = [self textureWithName:@"player_down01"];
			break;
		case OPLeft:
			textureID = [self textureWithName:@"player_left01"];
			break;
		case OPRight:
			textureID = [self textureWithName:@"player_right01"];
			break;
	}	
}

#pragma mark ===== Status Methods =====
- (void)incrementMaxHealth
{
	heartCount++;
	maxHealth += 2;
	currentHealth = maxHealth;
}

- (void)hurt
{
	if([NSDate timeIntervalSinceReferenceDate] - lastAttackTime > 0.5) {
		lastAttackTime = [NSDate timeIntervalSinceReferenceDate];
		currentHealth--;
		NSEnumerator	*enumerator = [health reverseObjectEnumerator];
		OPStatusHeart *aHeart = nil;
		while((aHeart = [enumerator nextObject]) != nil) {
			if([aHeart healthCount] != 0) {
				[aHeart decrementHealthCount];
				break;
			}
		}
	}
}


- (void)attack
{
	attacking = YES;
}

- (BOOL)isAttacking
{
	return attacking;
}

- (void)heal
{
	currentHealth++;
	NSEnumerator	*enumerator = [health objectEnumerator];
	OPStatusHeart *aHeart = nil;
	while((aHeart = [enumerator nextObject]) != nil) {
		if([aHeart healthCount] != 2) {
			[aHeart incrementHealthCount];
			break;
		}
	}
}

- (void)drawStatus
{
	OPPoint drawLocation = OPMakePoint(32 * 10, 32 * 11.25);
	glPushMatrix(); {
		glTranslated(drawLocation.x, drawLocation.y, 0);
		
		NSEnumerator	*enumerator = [health objectEnumerator];
		OPStatusHeart *aHeart = nil;
		while((aHeart = [enumerator nextObject]) != nil) {
			[aHeart draw];
		}
	}
	glPopMatrix();	
}

- (void)drawWeapon
{
	OPPoint drawLocation = OPMakePoint(32 * 6, 32 * 11.25);
	glPushMatrix(); {
		glTranslated(drawLocation.x, drawLocation.y, 0);
		[(OPSword *)weapon drawIcon];
	}
	glPopMatrix();		
}


- (void)setWeaponLocation
{
	switch(lastDirectionMoved) {
		case OPUp:
			[weapon setLocationX:location.x];
			[weapon setLocationY:location.y+16];
			[(OPSword *)weapon setSwordDirection:OPUp];
			break;
		case OPDown:
			[weapon setLocationX:location.x];
			[weapon setLocationY:location.y-16];
			[(OPSword *)weapon setSwordDirection:OPDown];
			break;
		case OPLeft:
			[weapon setLocationX:location.x-16];
			[weapon setLocationY:location.y-2];				
			[(OPSword *)weapon setSwordDirection:OPLeft];
			break;
		case OPRight:
			[weapon setLocationX:location.x+16];
			[weapon setLocationY:location.y-2];
			[(OPSword *)weapon setSwordDirection:OPRight];
			break;
	}
}

- (OPItem *)weapon
{
	return weapon;
}
@end
